#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include "dbe.h"

void dbe_ansi_font(HWND hwnd, int count, DBE_DIALOG_ITEM *items)
{
/* set controls in a dialog to use ANSI_VAR_FONT */
  int i;

  for (i=0; i<count; i++)
  {
    if (items[i].font)
    {
      SendMessage(GetDlgItem(hwnd, items[i].id), WM_SETFONT,
	(WPARAM) GetStockObject(ANSI_VAR_FONT), MAKELPARAM(TRUE, 0));
    }
  }
}

void dbe_check_button(HWND hwnd, int id, int flag)
{
/* set or reset a button based on a flag */
  if (flag) CheckDlgButton(hwnd, id, BST_CHECKED);
  else CheckDlgButton(hwnd, id, BST_UNCHECKED);
}

void *dbe_malloc(int size)
{
/* wrapper to malloc */

  void *ptr;

  ptr= malloc(size);
  if (!ptr)
  {
    fprintf(stderr, "Error: malloc call failed (size %d)\n", size);
    exit(0);
  }

  return ptr;
}

void dbe_free(void *ptr)
{
/* wrapper to free */

  free(ptr);
}

void *dbe_next_WORD(void *ptr)
{
/* move ptr to next WORD (2 byte) boundary */
  char *cptr= (char *) ptr;

  cptr += ((int)cptr)%2;

  return cptr;
}

void *dbe_next_DWORD(void *ptr)
{
/* move ptr to next DWORD (4 byte) boundary */
  char *cptr= (char *) ptr;

  cptr += ((int)cptr)%4;

  return cptr;
}

void *dbe_dialog_item(void *ptr, DWORD style, short x, short y, short cx, short cy, WORD id, WORD item_class, LPSTR txt)
{
/* write a template for a dialog item */
  DLGITEMTEMPLATE *dlgitem;
  int name_size;
  WORD *wptr;

/* dword align */
  dlgitem= dbe_next_DWORD(ptr);

/* window style */
  dlgitem->style= style;
  dlgitem->dwExtendedStyle= 0;

/* position and size */
  dlgitem->x= x;
  dlgitem->y= y;
  dlgitem->cx= cx;
  dlgitem->cy= cy;

/* child window identifier */
  dlgitem->id= id;

/* move ptr to end of dlgitem */
  dlgitem ++;
  ptr= dlgitem;

/* word align */
  wptr= dbe_next_WORD(ptr);

/* class */
  *wptr= 0xFFFF; wptr ++;
  *wptr= item_class; wptr ++;
  ptr= wptr;

/* text */
  name_size= MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, txt,
	-1, ptr, 100);
  ptr += name_size*2;
  wptr= ptr;

/* 0 length creation data */
  *wptr= 0;
  wptr ++;
  ptr= wptr;

  return ptr;
}

void *dbe_dialog_hdr(void *ptr, int item_count, short x, short y, short cx, short cy, LPSTR dlg_name)
{
/* write the main template for a dialog box */
  DLGTEMPLATE *dlg;
  WORD *wptr;
  int name_size;

  dlg= ptr;

/* window styles */
  dlg->style= WS_POPUP|WS_SYSMENU|WS_CAPTION|DS_MODALFRAME;
  dlg->dwExtendedStyle= 0;

/* number of dialog controls */
  dlg->cdit= item_count;

/* position and size */
  dlg->x= x;
  dlg->y= y;
  dlg->cx= cx;
  dlg->cy= cy;

/* move to end of template */
  dlg ++;
  ptr= dlg;

/* word align */
  wptr= dbe_next_WORD(ptr);

/* menu: none */
  *wptr= 0; wptr ++;

/* class: standard dialog box */
  *wptr= 0; wptr ++;
  ptr= wptr;

/* title */
  name_size= MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, dlg_name,
	-1, ptr, 100);
  ptr += name_size*2;

/* dword align for items */
  ptr= dbe_next_DWORD(ptr);

  return ptr;
}

int dbe_dialog_size(char *dialog_name, int item_count, DBE_DIALOG_ITEM *dialog_items)
{
/* return the size needed for a dialog template */
  int dialog_size;
  int i;

  dialog_size= sizeof(DLGTEMPLATE);
  dialog_size += dialog_size%2;
  dialog_size += 6 + strlen(dialog_name) * 2;

  for (i=0; i<item_count; i++)
  {
    dialog_size += dialog_size%4;
    dialog_size += sizeof(DLGITEMTEMPLATE);
    dialog_size += dialog_size%2;
    dialog_size += 8 + strlen(dialog_items[i].txt) * 2;
  }

  dialog_size += 4;

  return dialog_size;
}

void *dbe_dialog_create(int item_count, short x, short y, short cx, short cy, LPSTR txt, DBE_DIALOG_ITEM *items)
{
/* create a dialog template in memory */
  void *dlg_malloc;
  void *ptr;
  int i;

/* get memory */
  dlg_malloc= dbe_malloc(dbe_dialog_size(txt, item_count, items));
  ptr= dbe_next_DWORD(dlg_malloc);

/* main template */
  ptr= dbe_dialog_hdr(ptr, item_count, x, y, cx, cy, txt);

/* do each item */
  for (i= 0; i<item_count; i++)
    ptr= dbe_dialog_item(ptr, items[i].style, items[i].x, items[i].y,
		items[i].cx, items[i].cy, items[i].id,
		items[i].item_class, items[i].txt);

  return dlg_malloc;
}

