#ifndef __DBE_INCLUDES
#define __DBE_INCLUDES

#ifdef __cplusplus
extern "C" {
#endif

#ifndef DBE_TEXT_SIZE
#define DBE_TEXT_SIZE 256
#endif

typedef struct
{
  DWORD exstyle;
  DWORD style;
  short x;
  short y;
  short cx;
  short cy;
  WORD id;
  WORD item_class;
  char txt[DBE_TEXT_SIZE];
  int font;
} DBE_DIALOG_ITEM;

void *dbe_next_WORD(void *);
void *dbe_next_DWORD(void *);

void *dbe_dialog_create(int item_count, short x, short y, short cx, short cy, LPSTR txt, DBE_DIALOG_ITEM *items);

void dbe_ansi_font(HWND hwnd, int count, DBE_DIALOG_ITEM *items);
void dbe_check_button(HWND hwnd, int id, int flag);

void *dbe_malloc(int size);
void dbe_free(void *ptr);

#ifdef __cplusplus
}
#endif

#endif

