#include <stdio.h>
#include <windows.h>

#include "filebox.h"

int main(int argc, char *argv[])
{
  char name[250];
  char fullname[500];
  int rv;

  name[0]= (char) NULL;

  printf("Load file dialog - .c or .h extension\n");

  rv= filebox_dialog("Load file",	  /* dialog title */
			".c;.h",	  /* file extensions */
			FILEBOX_NO_STRIP, /* don't strip extensions */
			FILEBOX_LOAD,	  /* a load dialog */
			name,		  /* default filename */
			250,		  /* buffer size */
			fullname,	  /* returned filename */
			500);		  /* buffer size */
  if (rv==FILEBOX_OK)
    printf("Load file: %s\n", fullname);
  else if (rv==FILEBOX_CANCELLED)
    printf("Cancelled\n");
  else
    printf("Buffer string overflow\n");

  printf("Save file dialog - no extension\n");

  rv= filebox_dialog("Save file",	  /* dialog title */
			"",		  /* no file extension */
			FILEBOX_NO_STRIP, /* don't strip extensions */
			FILEBOX_SAVE,	  /* a save dialog */
			name,		  /* default filename */
			250,		  /* buffer size */
			fullname,	  /* returned filename */
			500);		  /* buffer size */
  if (rv==FILEBOX_OK)
    printf("Save file: %s\n", fullname);
  else if (rv==FILEBOX_CANCELLED)
    printf("Cancelled\n");
  else
    printf("Buffer string overflow\n");

  return 1;
}
