#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <windows.h>
#include "filebox.h"

/* max number of files */
#define FILEBOX_LISTSIZE 512

/* max number of file extensions */
#define FILEBOX_EXTNUM 100
#define FILEBOX_EXTSIZE 10

/* globals */
int filebox_ext_length[FILEBOX_EXTNUM]; /* file extension length */
char filebox_exts[FILEBOX_EXTNUM][FILEBOX_EXTSIZE]; /* file extension */
int filebox_ext_count;		/* number of file extensions */
int filebox_ext_strip;		/* flag for stripping file extension */
char *filebox_default;		/* default filename */
int filebox_default_size;	/* size of default filename buffer */
int filebox_path_set= 0;	/* flag for set path */
char filebox_path[FILEBOX_PATHSIZE]; /* current path */
char *filebox_returnname;	/* returned filename */
int filebox_returnname_size;	/* size of returnname buffer */
int filebox_save;		/* save flag */
int filebox_rv;			/* file dialog return value */
int filebox_dir_count;		/* number of directory names read in */
char filebox_dirs[FILEBOX_LISTSIZE][FILEBOX_NAMESIZE]; /* directory names */

/* Dialog box definitions */
#define FILEBOX_ITEMS 6

#define FILEBOX_LIST 100
#define FILEBOX_CURRENT_TXT 101
#define FILEBOX_PATH 102
#define FILEBOX_FILENAME 103
#define FILEBOX_CANCEL 104
#define FILEBOX_OK_BUTTON 105

/* array containing dialog item data */
DBE_DIALOG_ITEM filebox_list[FILEBOX_ITEMS]=
{
  {0, WS_TABSTOP|WS_VISIBLE|WS_CHILD|WS_BORDER|ES_AUTOHSCROLL, 3, 115, 147, 9, FILEBOX_FILENAME, 0x0081, "", 1},
  {0, WS_TABSTOP|WS_VISIBLE|WS_CHILD|WS_BORDER|LBS_NOTIFY|LBS_MULTICOLUMN|WS_HSCROLL, 3, 18, 224, 96, FILEBOX_LIST, 0x0083, "", 1},
  {0, WS_VISIBLE|WS_CHILD|SS_LEFTNOWORDWRAP, 3, 4, 39, 7, FILEBOX_CURRENT_TXT, 0x0082, "Current directory", 1},
  {0, WS_VISIBLE|WS_CHILD|WS_BORDER|ES_AUTOHSCROLL|ES_READONLY, 46, 3, 180, 9, FILEBOX_PATH, 0x0081, "", 1},
  {0, WS_TABSTOP|WS_VISIBLE|WS_CHILD|BS_PUSHBUTTON, 157, 114, 34, 11, FILEBOX_CANCEL, 0x0080, "Cancel", 1},
  {0, WS_TABSTOP|WS_VISIBLE|WS_CHILD|BS_DEFPUSHBUTTON, 193, 114, 34, 11, FILEBOX_OK_BUTTON, 0x0080, "OK", 1}
};

/* dialog box globals */
short filebox_x= 160;
short filebox_y= 100;
short filebox_cx= 229;
short filebox_cy= 126;

void next_line(FILE *fp)
{
/* search for next line in file */
  char ch;

  ch= getc(fp);

  while (ch != '\n' && !feof(fp))
    ch= getc(fp);
}

void next_space(FILE *fp)
{
/* search for next space in file */
  char ch;

  ch= getc(fp);

  while (ch != ' ' && !feof(fp))
    ch= getc(fp);
}

void filebox_get_exts(char *file_exts)
{
  int i= 0;
  int ext_i;

/* reset extension count */
  filebox_ext_count= 0;

  if (file_exts != NULL)
  {
/* loop until end of string */
    while (file_exts[i] != (char) NULL)
    {
      ext_i= 0;
      while (file_exts[i] != (char) NULL &&
	     file_exts[i] != ';')
      {
/* copy extension */
	filebox_exts[filebox_ext_count][ext_i]= tolower(file_exts[i]);
	ext_i ++;
	i ++;
      }

/* set terminator and length */
      filebox_exts[filebox_ext_count][ext_i]=(char) NULL;
      filebox_ext_length[filebox_ext_count]= ext_i;
      filebox_ext_count ++;

/* move to next extension */
      if (file_exts[i] == ';') i++;
    }
  }
}

int filebox_check_exts(char *filename)
{
  int name_len;
  int curr_ext;
  int ext_ok;
  int file_i;

  if (filename==NULL) return 0;

  name_len= strlen(filename);
/* compare file extensions */
  for (curr_ext=0; curr_ext < filebox_ext_count; curr_ext ++)
  {
    ext_ok= 1;
    for (file_i=0; file_i<filebox_ext_length[curr_ext]; file_i++)
    {
      if (tolower(filename[name_len-file_i-1]) !=
	  filebox_exts[curr_ext][filebox_ext_length[curr_ext]-file_i-1])
	ext_ok= 0;
    }

    if (ext_ok) return (curr_ext+1);
  }

  return 0;
}

void filebox_get_dir(FILE *fp, int *dir_count, char dirs[FILEBOX_LISTSIZE][FILEBOX_NAMESIZE])
{
/* read a directory name from list in file */
  int i= 0;
  char ch;

/* find next space and skip it */
  next_space(fp);

  ch= getc(fp);
  while (ch==' ') ch= getc(fp);

/* store directory name */
  while (ch!=' ' && ch!='\n' && ch!='/')
  {
    dirs[*dir_count][i]= ch;
    i ++;
    ch= getc(fp);
  }

/* set trailing '/' for directory */
  dirs[*dir_count][i]= '/';
  dirs[*dir_count][i+1]= (char) NULL;

/* move onto next line */
  if (ch!='\n') next_line(fp);

/* increment directory counter */
  (*dir_count) ++;
}

void filebox_get_file(FILE *fp, int *file_count, char files[FILEBOX_LISTSIZE][FILEBOX_NAMESIZE])
{
/* read in a filename from list in file */
  int i= 0;
  char ch;

/* move to next space and skip it */
  next_space(fp);

  ch= getc(fp);
  while (ch==' ') ch= getc(fp);

/* store filename */
  while (ch!=' ' && ch!='\n' && ch!='*')
  {
    files[*file_count][i]= ch;
    i ++;
    ch= getc(fp);
  }

  files[*file_count][i]= (char) NULL;

/* check file type */
  if (filebox_ext_count>0)
  {
    int this_ext;

    this_ext= filebox_check_exts(files[*file_count]);

/* extension matches */
    if (this_ext)
    {
      this_ext --;
      if (filebox_ext_strip)
/* strip extension off name */
	files[*file_count][i-filebox_ext_length[this_ext]]= (char) NULL;

      (*file_count) ++;
    }
  }
  else
  {
    (*file_count) ++;
  }

/* move to next line */
  if (ch!='\n') next_line(fp);
}

void filebox_set_filelist(HWND hwnd)
{
/* add filenames to dialog listbox */
  char files[FILEBOX_LISTSIZE][FILEBOX_NAMESIZE];
  char buf[FILEBOX_FULLNAMESIZE], f1[500], f2[500];
  int srv;
  int dir_count= 1; /* start at 1 because of parent directory */
  int file_count= 0;

/* remove previous entries */
  SendMessage(GetDlgItem(hwnd, FILEBOX_LIST), LB_RESETCONTENT, 0, 0);

/* set current filename */
  SetDlgItemText(hwnd, FILEBOX_FILENAME, filebox_default);
  SendMessage(GetDlgItem(hwnd, FILEBOX_FILENAME), EM_SETSEL, 0, -1);
  SetFocus(GetDlgItem(hwnd, FILEBOX_FILENAME));

/* no directories read in yet */
  filebox_dir_count= 0;

/* set parent directory */
  strcpy(filebox_dirs[0], "../");

/* set current path static text */
  SetDlgItemText(hwnd, FILEBOX_PATH, filebox_path);

/* get file list */
/* get temporary filenames using process id */
  sprintf(f1, "/tmp/dbelist%i", getpid());
  sprintf(f2, "/tmp/dbelistlog%i", getpid());

/* get file info, linked file, filename */
/* linked file before filename so can check link type before reading name */
/* need double space between linked file and filename */
/* (for files with no link $11 is empty) */
  sprintf(buf,"cd %s; /bin/ls -lF | /bin/awk '{print $1 \" \" $11 \"  \" $9}' > %s 2>%s",
	filebox_path, f1, f2);
  srv= system(buf);

  if (srv==0)
  {
/* command ran ok */
    FILE *fp;
    char ch;
    int i;

/* open filelist file */
    fp= fopen(f1, "r");

    if (fp)
    {
/* opened ok */
      while (!feof(fp)) {
/* check type for this line */
        ch= getc(fp);

        while (ch==' ') ch= getc(fp);

        if (ch=='d')
	{
/* directory */
	  filebox_get_dir(fp, &dir_count, filebox_dirs);
        }
	else if (ch=='-')
	{
/* file */
	  filebox_get_file(fp, &file_count, files);
        }
	else if (ch=='l')
	{
/* link - need to check whether a link to a file or directory */
	  char next;

/* move onto link name */
	  next_space(fp);
	  ch= getc(fp);
	  while (ch==' ') ch= getc(fp);

	  next= getc(fp);

/* move to end of link name */
	  while (next != ' ')
	  {
	    ch= next;
	    next= getc(fp);
	  }

/* check link type */
	  if (ch=='/')
/* directory */
	    filebox_get_dir(fp, &dir_count, filebox_dirs);
	  else
/* file */
	    filebox_get_file(fp, &file_count, files);
        }
	else
	{
/* ignore this line */
	  next_line(fp);
        }

      }

/* set listbox values */
/* directory list */
      for (i=0 ; i<dir_count; i++)
      {
        SendMessage(GetDlgItem(hwnd, FILEBOX_LIST), LB_ADDSTRING, 0,
		(WPARAM) filebox_dirs[i]);
      }

/* set number of directories */
      filebox_dir_count= dir_count;

/* filename list */
      for (i=0; i<file_count; i++)
      {
        SendMessage(GetDlgItem(hwnd, FILEBOX_LIST), LB_ADDSTRING, 0,
		(WPARAM) files[i]);
      }

/* close file list */
      fclose(fp);

/* erase the temporary files */
      sprintf(buf, "rm -f %s %s", f1, f2);
      system(buf);
    }
  }
}

int filebox_selection(char *filename)
{
  int sel;
  int len;
  int i;

/* reset selection to "filename" */
  sel= filebox_dir_count;

/* add trailing slash for directory name comparisons */
  len= strlen(filename);
  if (filename[len-1]!='/')
  {
    filename[len]= '/';
    filename[len+1]= (char) NULL;
  }

/* check directories */
  for (i=0; i<filebox_dir_count; i++)
  {
    if (!strcmp(filename, filebox_dirs[i]))
      sel= i;
  }

/* remove trailing slash for a filename */
  if (sel==filebox_dir_count)
    filename[len]= (char) NULL;

  return sel;
}

int filebox_do_ok(HWND hwnd)
{
/* ok button pressed or name double clicked */
  char filename[FILEBOX_NAMESIZE];
  char fullname[FILEBOX_FULLNAMESIZE];
  int i;
  int file_i;
  int rv= 1;
  FILE *test_fp;
  int selection;

/* get filename */
  GetDlgItemText(hwnd, FILEBOX_FILENAME, filename, FILEBOX_NAMESIZE-1);

/* get filename id */
  selection= filebox_selection(filename);

/* check what clicked on */
/* 0 for parent, 1 to filebox_dir_count-1 for a directory, */
/* filebox_dir_count for a file */
  if (selection==0)
  {
/* '../'  up a level */
    rv= 0;
    i= 0;

/* get end of current path */
    while (filebox_path[i]!=(char)NULL) i++;

    if (i>1)
    {
/* there is a level to go up */
/* set new path */
      while (filebox_path[i]!='/') i--;
      if (i>0) filebox_path[i]= (char) NULL;
	else filebox_path[1]= (char) NULL;
/* need to reset current directory and file list */
      filebox_set_filelist(hwnd);
    }
  }
  else if (selection < filebox_dir_count)
  {
/* clicked on a directory name */
    char tmp[FILEBOX_PATHSIZE];

    i= 0;
    rv= 0;

/* directory names terminated by '/' */
    while (filename[i]!='/') i++;
    filename[i]= (char) NULL;

    if (filebox_path[1]==(char) NULL)
/* current path is '/' */
      sprintf(tmp, "/%s", filename);
    else
/* longer current path */
      sprintf(tmp, "%s/%s", filebox_path, filename);

    strcpy(filebox_path, tmp);

/* change directory and file list */
    filebox_set_filelist(hwnd);
  }
  else
  {
/* clicked on a filename */
/* get end of filename */
    i= 0;
    while (filename[i] != (char) NULL) i++;

/* check for empty filename */
    if (i==0)
    {
/* return FILEBOX_CANCELLED from dialog */
      filebox_rv= FILEBOX_CANCELLED;
    }
    else
    {
/* check tail is ok */
      if (filebox_ext_count>0)
      {
	if (!filebox_check_exts(filename))
	{
/* add first extension */
	  for (file_i=0; file_i<=filebox_ext_length[0]; file_i++)
	    filename[i+file_i]= filebox_exts[0][file_i];
        }
      }

/* set full path for filename */
      sprintf(fullname, "%s/%s", filebox_path, filename);

/* check for existing file */
      test_fp= fopen(fullname, "r");

      if (test_fp)
      {
/* file exists */
	fclose(test_fp);
      }

      if (test_fp)
      {
	if (filebox_save)
	{
	  char buff[FILEBOX_NAMESIZE];

          sprintf(buff, "File %s exists: overwrite?", filename);
/* disable messages to dialog window */
	  EnableWindow(hwnd, 0);
          if (MessageBox(NULL, buff, "Warning", MB_OKCANCEL)==IDCANCEL)
/* don't overwrite */
	    rv= 0;
/* enable messages to dialog window */
	  EnableWindow(hwnd, 1);
	  BringWindowToTop(hwnd);
	}
      }
      else if (!filebox_save)
      {
/* filename doesn't exist */
/* ignore "OK" for load */

/* disable messages to dialog window */
	EnableWindow(hwnd, 0);
	MessageBox(NULL, "Filename invalid", "Error", MB_OK);
/* enable messages to dialog window */
	EnableWindow(hwnd, 1);
	BringWindowToTop(hwnd);

	rv= 0;
      }

      if (filebox_rv && rv)
      {
/* set default filename */
	if (strlen(filename)<filebox_default_size)
	{
	  strcpy(filebox_default, filename);

/* set full path and filename */
	  if (strlen(fullname)<filebox_returnname_size)
	    strcpy(filebox_returnname, fullname);
	  else
	    filebox_rv= FILEBOX_OVERFLOW;
	}
	else
	{
	  filebox_rv= FILEBOX_OVERFLOW;
	}
      }
    }
  }

  return rv;
}

BOOL CALLBACK filebox_event(HWND hwnd, UINT umsg, WPARAM wparam, LPARAM lparam)
{
/* file dialog event handler */
  int sel;
  char buff[FILEBOX_NAMESIZE];

  switch (umsg)
  {
    case WM_INITDIALOG:
      dbe_ansi_font(hwnd, FILEBOX_ITEMS, filebox_list);

/* want multiple columns for file list */
      SendMessage(GetDlgItem(hwnd, FILEBOX_LIST), LB_SETCOLUMNWIDTH,
		(WPARAM) 150, 0);
/* set directory and file list */
      filebox_set_filelist(hwnd);
      return 1;
    case WM_MOVE:
      filebox_x= LOWORD (lparam)/2;
      filebox_y= HIWORD (lparam)/2;
      return 1;
    case WM_QUIT:
    case WM_DESTROY:
      EndDialog(hwnd, 0);
      return 1;
    case WM_COMMAND:
      switch (LOWORD(wparam))
      {
        case IDCANCEL:
	case FILEBOX_CANCEL:
	  filebox_rv= FILEBOX_CANCELLED;
          EndDialog(hwnd, 0);
          return 1;
	case FILEBOX_OK_BUTTON:
	  if (filebox_do_ok(hwnd))
	    EndDialog(hwnd, 0);
	  return 1;
	case FILEBOX_LIST:
/* directory and filename list clicked */
	  switch (HIWORD(wparam))
	  {
	    case LBN_SELCHANGE:
/* current selection changed */
/* get current selection */
	      sel= SendMessage(GetDlgItem(hwnd, FILEBOX_LIST),
			LB_GETCURSEL, 0, 0);
	      if (sel != LB_ERR)
	      {
/* got selection ok */
/* set the selection text */
		SendMessage(GetDlgItem(hwnd, FILEBOX_LIST),
			LB_GETTEXT, sel, (LPARAM) buff);
/* set in current filename editbox */
		SetDlgItemText(hwnd, FILEBOX_FILENAME, buff);
	      }
	      return 1;
	    case LBN_DBLCLK:
/* get current selection */
	      sel= SendMessage(GetDlgItem(hwnd, FILEBOX_LIST),
			LB_GETCURSEL, 0, 0);
	      if (sel != LB_ERR)
	      {
/* got selection ok */
		SendMessage(GetDlgItem(hwnd, FILEBOX_LIST),
			LB_GETTEXT, sel, (LPARAM) buff);
/* set in current filename editbox */
		SetDlgItemText(hwnd, FILEBOX_FILENAME, buff);
		if (filebox_do_ok(hwnd))
		  EndDialog(hwnd, 0);
	      }
	      return 1;
	    default:
	      return 0;
	  }
        default:
          return 0;
      }
    default:
      return 0;
  }
}

void filebox_default_path(void)
{
/* need to get current path */
  char buff[500];
  FILE *fp;
  char f1[500];

/* temporary filename */
  sprintf(f1, "/tmp/fileboxpwd%i", getpid());

/* get working directory */
  sprintf(buff, "echo $PWD > %s", f1);
  system(buff);

  fp= fopen(f1, "r");
  if (fp)
  {
/* file opened ok */
/* get file path */
    fscanf(fp, "%s", filebox_path);
    fclose(fp);
  }
  else
  {
/* set root as current path */
    filebox_path[0]= '/';
    filebox_path[1]= (char) NULL;
  }

/* remove temporary files */
  sprintf(buff, "rm -f %s", f1);
  system(buff);

/* set path flag */
  filebox_path_set= 1;
}

int filebox_dialog(char *dialog_title, char *file_ext, int ext_strip, int save_flag, char *default_name, int default_size, char *name, int name_size)
{
/* create a filebox dialog */
/* return 1 for filename chosen, 0 for no filename chosen */
  void *filebox_start;

/* store globals */
  filebox_save= save_flag;
  filebox_get_exts(file_ext);
  filebox_ext_strip= ext_strip;
  filebox_default= default_name;
  filebox_default_size= default_size;
  filebox_returnname= name;
  filebox_returnname_size= name_size;

/* set return value */
  filebox_rv= FILEBOX_OK;

  if (!filebox_path_set)
    filebox_default_path();

/* create dialog box */
  filebox_start= dbe_dialog_create(FILEBOX_ITEMS,
        filebox_x-2, filebox_y-11,
	filebox_cx, filebox_cy,
	dialog_title, filebox_list);

/* run dialog box */
  DialogBoxIndirect(GetModuleHandle(NULL), dbe_next_DWORD(filebox_start),
	NULL, filebox_event);

  dbe_free(filebox_start);

/* return value set in event handler */
  return filebox_rv;
}

int filebox_get_path(char *path_name, int buff_size)
{
  int path_len;

  if (!filebox_path_set)
    filebox_default_path();

  path_len= strlen(filebox_path)+1;
  if (buff_size<path_len) return path_len;

  strcpy(path_name, filebox_path);

  return 0;
}

void filebox_set_path(char *path_name)
{
  strcpy(filebox_path, path_name);
}

